unit setzone;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, Mask, JvExMask, JvToolEdit, JvMaskEdit;

type
  TdlgSetZone = class(TForm)
    OKBtn: TButton;
    CancelBtn: TButton;
    Bevel1: TBevel;
    Label1: TLabel;
    Label2: TLabel;
    JvMaskEdit1: TJvMaskEdit;
    CheckBox1: TCheckBox;
    ComboBox1: TComboBox;
    CheckBox2: TCheckBox;
  private
    { Private declarations }
  public
    { Public declarations }
    function DoIt(s:string):string;
  end;

var
  dlgSetZone: TdlgSetZone;

implementation

{$R *.dfm}

{ TdlgSetZone }

// Zone 04  +00:00  0:No DST,12 hr
// 000000000111111111122222222223
// 123456789012345678901234567890

function TdlgSetZone.DoIt(s: string): string;
var s1:string;
i:Integer;

begin
  Label1.Caption:=Copy(s,1,7);
  JvMaskEdit1.Text:=Copy(s,11,5);
  if s[10]='-' then
    CheckBox1.Checked:=True
  else
    CheckBox1.Checked:=False;

  s1:=Copy(s,18,255);
  // find position of :
  i:=Pos(':',s1);
  ComboBox1.ItemIndex:=StrToInt(Copy(s1,1,i-1));
  // find pos of ,
  i:=Pos(',',s1);
  if s1[i+1]='2' then
    CheckBox2.Checked:=True
  else
    CheckBox2.Checked:=False;

  if ShowModal<>mrOK then
  begin
    Result:=s;
    Exit;
  end;

  // ok now combine
  Result:=Copy(s,1,7)+'  ';
  if CheckBox1.Checked then
    Result:=Result + '-'
  else
    Result:=Result + '+';

  Result:=Result + JvMaskEdit1.Text + '  ' + IntToStr(ComboBox1.ItemIndex) +
      ':' + ComboBox1.Items[ComboBox1.ItemIndex] + ',';

  if CheckBox2.Checked then
    Result:=Result + '24 hr'
  else
    Result:=Result + '12 hr';


end;

end.
